<?php
/**
* Liquid Shape Divider Options
*/

if( !defined( 'ABSPATH' ) )
	exit; // Exit if accessed directly

/**
 * [liquid_param_select_preview description]
 * @method liquid_param_select_preview
 * @param  [type]               $settings [description]
 * @param  [type]               $value    [description]
 * @return [type]                         [description]
 */
/*
vc_add_shortcode_param( 'css_responsive_editor', 'liquid_param_responsive_options' );
function liquid_param_responsive_options( $settings, $value ) {

	return 'Hi';

}
*/
if( ! class_exists( 'Liquid_Shape_Divider_Options' ) ) {

	class Liquid_Shape_Divider_Options  {

		/**
		 * @var array
		 */
		protected $positions = array( 'top', 'bottom' );

		function __construct() {

			if ( function_exists( 'vc_add_shortcode_param' ) ) {
				vc_add_shortcode_param( 'liquid_shape_divider', array( $this, 'shape_divider_param' ) );
			}
		}

		function shape_divider_param( $settings, $value ) {

			$label  = isset( $settings['label'] ) ? $settings['label'] : esc_html__( 'Shape Divider Options', 'ave-core' );
			$values = $this->get_shape_divider_values( $value );

			$positions = $this->positions;
			$i = 0;

			$output = '<div class="vc_css-editor vc_row vc_ui-flex-row">';
			$output .= '	<div class="vc_col-xs-12 liquid-shape-divider-tabs">';
			$output .= '		<h3 class="liquid-shape-divider-heading top active" data-target="top">' .  esc_html__( 'Top Divider', 'ave-core' )  . '</h3>';
			$output .= '		<h3 class="liquid-shape-divider-heading bottom" data-target="bottom">' .  esc_html__( 'Bottom Divider', 'ave-core' )  . '</h3>';
			$output .= '	</div>';
			
			foreach( $positions as $position ) {

				$hidden = ( $i != 0 ) ? 'hidden' : '';

				$output .= '	<div class="vc_col-xs-12 liquid_shape_divider_settings ' . $hidden . '" data-position="' . $position . '">';
				$output .= '		<div class="vc_row">';
				$output .= '			<div class="liquid_shape_divider_preview vc_col-xs-6"><div class="liquid_shape"></div></div>';
				$output .= '			<div class="vc_col-xs-6">';

				$output .= '<div class="liquid-main-responsive-wrapper ">';
				$output .= '	<div class="liquid-inner-wrap">';

				// Shape type select
				$output .= '	<label>' . esc_html__( 'Shape Type', 'ave-core' ) . '</label>'
						. '	 	<div class="liquid_shape_divider-type">'
						. '			<select data-name="' . $position . '-shape-type" data-preview-target=".liquid_shape" name="' . $position . '_shape_type" class="liquid_shape_divider-type">'
						.				$this->getShapeTypeOptions( $position,  $values )
						. '			</select>'
						. '		</div>';

				// Shape divider height
				$output .= '	<label>' . esc_html__( 'Height', 'ave-core' ) . '</label>'
						. '	 	<div class="liquid_shape_divider-height">'
						.			$this->getShapeHeight( $position,  $values )
						. '		</div>';

				// Shape divider backround color
				$output .= '	<label>' . esc_html__( 'Color', 'ave-core' ) . '</label>'
						. '	 	<div class="liquid_shape_divider-color">'
						.			$this->getShapeColor( $position,  $values )
						. '		</div>';

				$output .= '	</div>'; //.liquid-inner-wrap
				$output .= '</div>'; // .liquid-main-shape_divider-wrapper

				$i++;

				$output .= '			</div>'; //.vc_col-xs-6
				$output .= '		</div>'; //.row
				$output .= '	</div>'; //.vc_col-xs-12
				
			}
			$output .= '	<input name="' . $settings['param_name'] . '" class="wpb_vc_param_value  ' . $settings['param_name'] . ' ' . $settings['type'] . '_field" type="hidden" value="' . $value . '" />';
			$output .= '</div>'; // .liquid-shape-divider-container

			return $output;

		}

		public static function get_shape_divider_values( $value ) {
			return vc_parse_multi_attribute( $value, array( 'top_shape_type' => '', 'top_shape_color' => '', 'top_shape_height' => '', 'top_shape_width' => '', 'top_shape_flip' => '', 'top_shape_inverse' => '', 'bottom_shape_type' => '', 'bottom_shape_color' => '', 'bottom_shape_height' => '', 'bottom_shape_width' => '', 'bottom_shape_flip' => '', 'bottom_shape_inverse' => '' ) );
		}

		/**
		 * @return string
		 */
		function getShapeTypeOptions( $position, $values = array() ) {
			$output = '<option data-svg-path="" value="">' . esc_html__( 'None', 'ave-core' ) . '</option>';
			$styles = apply_filters( 'liquid_shape_divider_type_options_data', array(
				'1',
				'2',
				'3',
				'4',
				'5',
				'6',
				'7',
				'8',
				'9',
			) );
			foreach ( $styles as $key => $style ) {
				$selected = '';
				if( $style === $values[ $position . '_shape_type'] ) {
					$selected = 'selected';
				}  	
					$output .= '<option ' . $selected . ' data-svg-path="' . get_template_directory_uri() . '/assets/img/svg-divider/' . $style . '.svg' . '" value="' . $style . '">' . $style  . '</option>';
				}
			return $output;
		}


		function getShapeColor( $position, $values = array() ) {

			$output = '<input type="text" data-name="' . $position . '-shape-color" name="' . $position . '_shape_color" value="' . $values[ $position . '_shape_color' ] . '" class="liquid_color-control">';

			return $output;

		}

		function getShapeHeight( $position, $values = array() ) {

			return '<div class="liquid-slider"><div class="liquid-handle ui-slider-handle"></div></div><input type="hidden" data-name="' . $position . '-shape-height" name="' . $position . '_shape_height" value="' . $values[ $position . '_shape_height' ] . '" class="liquid_shape_height-control liquid-sliderinput" >';

		}

		function getShapeWidth( $position, $values = array() ) {

			return '<div class="liquid-slider"><div class="liquid-handle ui-slider-handle"></div></div><input type="hidden" data-name="' . $position . '-shape-width" name="' . $position . '_shape_weight" value="' . $values[ $position . '_shape_weight' ] . '" class="liquid_shape_weight-control liquid-sliderinput">';

		}

		function getTopShape( $values = array() ) {
			return file_get_contents( get_template_directory() . '/assets/img/svg-divider/' . $values[ 'top_shape_type' ] . '.svg' );
		}

		function getBottomShape( $values = array() ) {
			return file_get_contents( get_template_directory() . '/assets/img/svg-divider/' . $values[ 'bottom_shape_type' ] . '.svg' );
		}


		public static function getShape( $value, $pos = 'top' ) {

			if( empty( $value ) ){
				return;
			}

			$values = Liquid_Shape_Divider_Options::get_shape_divider_values( $value );
			if( ! isset( $values[ $pos . '_shape_type' ] ) || empty( $values[ $pos . '_shape_type' ] ) ) {
				return;
			}

			$shape = $values[ $pos . '_shape_type' ];
			$svg = '';

			switch( $shape ) {

				case '1':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '90';
					$svg = '<svg fill="' . $color . '" width="100%" height="102"  viewBox="0 0 100 102" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
						<path transform="rotate(180 50,51.930503845214844) " d="m0,1.9305l50,100l50,-100l-100,0z"/>
					</svg>';
					break;
					
				case '2':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '100';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100" viewBox="0 0 100 100" preserveAspectRatio="none">
								<path d="M0 100 C40 0 60 0 100 100 Z"/>
							</svg>';
					break;
					
				case '3':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '119';
					$svg = '<svg fill="' . $color . '" width="100%" height="119px" viewBox="0 0 1000 119" version="1.1" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M1000 0.5 1000 118.33 0 118.33 719.760966 33.5145112z"></path>
					</svg>';
					break;
					
				case '4':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '182';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="100%" height="182" viewBox="0 0 1920 182" preserveAspectRatio="none">
						<path d="M1921.91,916.348c0.33,39.216-.34,79.431,0,118.642Q957.95,1035.5-6,1035V853c40.431,10.8,81,19.794,122.5,27.149,62.957,11.157,117.371,15.375,180.742,21.116,79.864,7.236,165.843,26.989,255.045,42.232,109.142,18.65,243.949,40.091,308.265,44.243,137.637,8.886,313.056-2.783,504.066-36.2,127.4-22.286,223.4-43.261,354.45-45.248A1569.414,1569.414,0,0,1,1921.91,916.348Z" transform="translate(0 -853)"/>
					</svg>';
					break;
					
				case '5':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '108';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="155" height="108" viewBox="0 0 155 108">
								<polygon points="1274.5 3682 1352 3790 1197 3790" transform="matrix(1 0 0 -1 -1197 3790)"/>
							</svg>';				
				break;
					
				case '6':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '68';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 68" preserveAspectRatio="none">
									<path d="m1622.3 1937.7c0 0-410.7 169.1-913.4 75.5-502.7-93.6-977.7 56.3-977.7 56.3v440h1891.1v-571.8" transform="translate(0-1977)"></path>
								</svg>';
				break;
				case '7':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '9';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="1440" height="9" viewBox="0 0 1440 9" preserveAspectRatio="none">
							  <path d="M1379,9.92687204e-05 C1380.76992,9.92687204e-05 1382.53969,0.677111942 1383.8855,2.03074021 L1386.94548,5.11740181 C1389.63201,7.8270408 1394.03086,7.8270408 1396.71693,5.11740181 L1399.77999,2.03074021 C1402.46652,-0.676913405 1406.86276,-0.676913405 1409.54883,2.03074021 L1412.61389,5.11740181 C1415.29842,7.8270408 1419.69712,7.8270408 1422.38334,5.11740181 L1425.44594,2.03074021 C1428.13493,-0.676913405 1432.53179,-0.676913405 1435.21785,2.03074021 L1438.28045,5.11978426 C1440.96991,7.82743787 1445.36599,7.82743787 1448.05221,5.11978426 L1451.11527,2.03074021 C1453.80196,-0.676913405 1458.19758,-0.676913405 1460.88704,2.03074021 L1463.94732,5.11740181 C1466.63324,7.8270408 1471.03225,7.8270408 1473.71862,5.11740181 L1476.78153,2.03074021 C1479.46775,-0.676913405 1483.86445,-0.676913405 1486.55314,2.03074021 L1489.61343,5.11740181 C1492.30227,7.8270408 1496.69866,7.8270408 1499.38488,5.11740181 L1502.44779,2.03074021 C1505.13416,-0.676913405 1509.53025,-0.676913405 1512.21724,2.03074021 L1515.2803,5.11740181 C1517.96667,7.8270408 1522.36291,7.8270408 1525.05175,5.11740181 L1528.11435,2.03074021 C1529.45754,0.675920717 1531.22962,-0.00228318057 1533,9.92687204e-05 L1533,9 L1379,9 L1226,9 L1073,9 L919,9 L766,9 L613,9 L460,9 L307,9 L154,9 L0,9 L0,9.92687204e-05 C1.769922,9.92687204e-05 3.53969,0.677111942 4.885496,2.03074021 L7.945476,5.11740181 C10.632006,7.8270408 15.030862,7.8270408 17.71693,5.11740181 L20.77999,2.03074021 C23.46652,-0.676913405 27.862758,-0.676913405 30.548826,2.03074021 L33.613888,5.11740181 C36.298416,7.8270408 40.697118,7.8270408 43.38334,5.11740181 L46.445938,2.03074021 C49.134932,-0.676913405 53.531786,-0.676913405 56.217854,2.03074021 L59.280452,5.11978426 C61.969908,7.82743787 66.365992,7.82743787 69.052214,5.11978426 L72.115274,2.03074021 C74.801958,-0.676913405 79.19758,-0.676913405 81.887036,2.03074021 L84.947324,5.11740181 C87.633238,7.8270408 92.032248,7.8270408 94.718624,5.11740181 L97.78153,2.03074021 C100.467752,-0.676913405 104.864452,-0.676913405 107.553138,2.03074021 L110.613426,5.11740181 C113.302266,7.8270408 117.698658,7.8270408 120.38488,5.11740181 L123.447786,2.03074021 C126.134162,-0.676913405 130.530246,-0.676913405 133.217238,2.03074021 L136.280298,5.11740181 C138.966674,7.8270408 143.362912,7.8270408 146.051752,5.11740181 L149.11435,2.03074021 C150.203951,0.93170321 151.575786,0.277916034 153,0.0714983408 L153,9.92687204e-05 C153.165404,9.92687204e-05 153.330806,0.00601187356 153.495861,0.0178367592 C153.663677,0.0057866107 153.831846,-0.000127020259 154,9.92687204e-05 L154,0.0725499097 C155.423321,0.279975174 156.793877,0.93277591 157.885496,2.03074021 L160.945476,5.11740181 C163.632006,7.8270408 168.030862,7.8270408 170.71693,5.11740181 L173.77999,2.03074021 C176.46652,-0.676913405 180.862758,-0.676913405 183.548826,2.03074021 L186.613888,5.11740181 C189.298416,7.8270408 193.697118,7.8270408 196.38334,5.11740181 L199.445938,2.03074021 C202.134932,-0.676913405 206.531786,-0.676913405 209.217854,2.03074021 L212.280452,5.11978426 C214.969908,7.82743787 219.365992,7.82743787 222.052214,5.11978426 L225.115274,2.03074021 C227.801958,-0.676913405 232.19758,-0.676913405 234.887036,2.03074021 L237.947324,5.11740181 C240.633238,7.8270408 245.032248,7.8270408 247.718624,5.11740181 L250.78153,2.03074021 C253.467752,-0.676913405 257.864452,-0.676913405 260.553138,2.03074021 L263.613426,5.11740181 C266.302266,7.8270408 270.698658,7.8270408 273.38488,5.11740181 L276.447786,2.03074021 C279.134162,-0.676913405 283.530246,-0.676913405 286.217238,2.03074021 L289.280298,5.11740181 C291.966674,7.8270408 296.362912,7.8270408 299.051752,5.11740181 L302.11435,2.03074021 C303.203951,0.93170321 304.575786,0.277916034 306,0.0714983408 L306,9.92687204e-05 C306.165404,9.92687204e-05 306.330806,0.00601187356 306.495861,0.0178367592 C306.663677,0.0057866107 306.831846,-0.000127020259 307,9.92687204e-05 L307,0.0725499097 C308.423321,0.279975174 309.793877,0.93277591 310.885496,2.03074021 L313.945476,5.11740181 C316.632006,7.8270408 321.030862,7.8270408 323.71693,5.11740181 L326.77999,2.03074021 C329.46652,-0.676913405 333.862758,-0.676913405 336.548826,2.03074021 L339.613888,5.11740181 C342.298416,7.8270408 346.697118,7.8270408 349.38334,5.11740181 L352.445938,2.03074021 C355.134932,-0.676913405 359.531786,-0.676913405 362.217854,2.03074021 L365.280452,5.11978426 C367.969908,7.82743787 372.365992,7.82743787 375.052214,5.11978426 L378.115274,2.03074021 C380.801958,-0.676913405 385.19758,-0.676913405 387.887036,2.03074021 L390.947324,5.11740181 C393.633238,7.8270408 398.032248,7.8270408 400.718624,5.11740181 L403.78153,2.03074021 C406.467752,-0.676913405 410.864452,-0.676913405 413.553138,2.03074021 L416.613426,5.11740181 C419.302266,7.8270408 423.698658,7.8270408 426.38488,5.11740181 L429.447786,2.03074021 C432.134162,-0.676913405 436.530246,-0.676913405 439.217238,2.03074021 L442.280298,5.11740181 C444.966674,7.8270408 449.362912,7.8270408 452.051752,5.11740181 L455.11435,2.03074021 C456.203951,0.93170321 457.575786,0.277916034 459,0.0714983408 L459,9.92687204e-05 C459.165404,9.92687204e-05 459.330806,0.00601187356 459.495861,0.0178367592 C459.663677,0.0057866107 459.831846,-0.000127020259 460,9.92687204e-05 L460,0.0725499097 C461.423321,0.279975174 462.793877,0.93277591 463.885496,2.03074021 L466.945476,5.11740181 C469.632006,7.8270408 474.030862,7.8270408 476.71693,5.11740181 L479.77999,2.03074021 C482.46652,-0.676913405 486.862758,-0.676913405 489.548826,2.03074021 L492.613888,5.11740181 C495.298416,7.8270408 499.697118,7.8270408 502.38334,5.11740181 L505.445938,2.03074021 C508.134932,-0.676913405 512.531786,-0.676913405 515.217854,2.03074021 L518.280452,5.11978426 C520.969908,7.82743787 525.365992,7.82743787 528.052214,5.11978426 L531.115274,2.03074021 C533.801958,-0.676913405 538.19758,-0.676913405 540.887036,2.03074021 L543.947324,5.11740181 C546.633238,7.8270408 551.032248,7.8270408 553.718624,5.11740181 L556.78153,2.03074021 C559.467752,-0.676913405 563.864452,-0.676913405 566.553138,2.03074021 L569.613426,5.11740181 C572.302266,7.8270408 576.698658,7.8270408 579.38488,5.11740181 L582.447786,2.03074021 C585.134162,-0.676913405 589.530246,-0.676913405 592.217238,2.03074021 L595.280298,5.11740181 C597.966674,7.8270408 602.362912,7.8270408 605.051752,5.11740181 L608.11435,2.03074021 C609.203951,0.93170321 610.575786,0.277916034 612,0.0714983408 L612,9.92687204e-05 C612.165404,9.92687204e-05 612.330806,0.00601187356 612.495861,0.0178367592 C612.663677,0.0057866107 612.831846,-0.000127020259 613,9.92687204e-05 L613,0.0725499097 C614.423321,0.279975174 615.793877,0.93277591 616.885496,2.03074021 L619.945476,5.11740181 C622.632006,7.8270408 627.030862,7.8270408 629.71693,5.11740181 L632.77999,2.03074021 C635.46652,-0.676913405 639.862758,-0.676913405 642.548826,2.03074021 L645.613888,5.11740181 C648.298416,7.8270408 652.697118,7.8270408 655.38334,5.11740181 L658.445938,2.03074021 C661.134932,-0.676913405 665.531786,-0.676913405 668.217854,2.03074021 L671.280452,5.11978426 C673.969908,7.82743787 678.365992,7.82743787 681.052214,5.11978426 L684.115274,2.03074021 C686.801958,-0.676913405 691.19758,-0.676913405 693.887036,2.03074021 L696.947324,5.11740181 C699.633238,7.8270408 704.032248,7.8270408 706.718624,5.11740181 L709.78153,2.03074021 C712.467752,-0.676913405 716.864452,-0.676913405 719.553138,2.03074021 L722.613426,5.11740181 C725.302266,7.8270408 729.698658,7.8270408 732.38488,5.11740181 L735.447786,2.03074021 C738.134162,-0.676913405 742.530246,-0.676913405 745.217238,2.03074021 L748.280298,5.11740181 C750.966674,7.8270408 755.362912,7.8270408 758.051752,5.11740181 L761.11435,2.03074021 C762.203951,0.93170321 763.575786,0.277916034 765,0.0714983408 L765,9.92687204e-05 C765.165404,9.92687204e-05 765.330806,0.00601187356 765.495861,0.0178367592 C765.663677,0.0057866107 765.831846,-0.000127020259 766,9.92687204e-05 L766,0.0725499097 C767.423321,0.279975174 768.793877,0.93277591 769.885496,2.03074021 L772.945476,5.11740181 C775.632006,7.8270408 780.030862,7.8270408 782.71693,5.11740181 L785.77999,2.03074021 C788.46652,-0.676913405 792.862758,-0.676913405 795.548826,2.03074021 L798.613888,5.11740181 C801.298416,7.8270408 805.697118,7.8270408 808.38334,5.11740181 L811.445938,2.03074021 C814.134932,-0.676913405 818.531786,-0.676913405 821.217854,2.03074021 L824.280452,5.11978426 C826.969908,7.82743787 831.365992,7.82743787 834.052214,5.11978426 L837.115274,2.03074021 C839.801958,-0.676913405 844.19758,-0.676913405 846.887036,2.03074021 L849.947324,5.11740181 C852.633238,7.8270408 857.032248,7.8270408 859.718624,5.11740181 L862.78153,2.03074021 C865.467752,-0.676913405 869.864452,-0.676913405 872.553138,2.03074021 L875.613426,5.11740181 C878.302266,7.8270408 882.698658,7.8270408 885.38488,5.11740181 L888.447786,2.03074021 C891.134162,-0.676913405 895.530246,-0.676913405 898.217238,2.03074021 L901.280298,5.11740181 C903.966674,7.8270408 908.362912,7.8270408 911.051752,5.11740181 L914.11435,2.03074021 C915.457538,0.675920717 917.229616,-0.00228318057 919,9.92687204e-05 C920.769922,9.92687204e-05 922.53969,0.677111942 923.885496,2.03074021 L926.945476,5.11740181 C929.632006,7.8270408 934.030862,7.8270408 936.71693,5.11740181 L939.77999,2.03074021 C942.46652,-0.676913405 946.862758,-0.676913405 949.548826,2.03074021 L952.613888,5.11740181 C955.298416,7.8270408 959.697118,7.8270408 962.38334,5.11740181 L965.445938,2.03074021 C968.134932,-0.676913405 972.531786,-0.676913405 975.217854,2.03074021 L978.280452,5.11978426 C980.969908,7.82743787 985.365992,7.82743787 988.052214,5.11978426 L991.115274,2.03074021 C993.801958,-0.676913405 998.19758,-0.676913405 1000.88704,2.03074021 L1003.94732,5.11740181 C1006.63324,7.8270408 1011.03225,7.8270408 1013.71862,5.11740181 L1016.78153,2.03074021 C1019.46775,-0.676913405 1023.86445,-0.676913405 1026.55314,2.03074021 L1029.61343,5.11740181 C1032.30227,7.8270408 1036.69866,7.8270408 1039.38488,5.11740181 L1042.44779,2.03074021 C1045.13416,-0.676913405 1049.53025,-0.676913405 1052.21724,2.03074021 L1055.2803,5.11740181 C1057.96667,7.8270408 1062.36291,7.8270408 1065.05175,5.11740181 L1068.11435,2.03074021 C1069.20395,0.93170321 1070.57579,0.277916034 1072,0.0714983408 L1072,9.92687204e-05 C1072.1654,9.92687204e-05 1072.33081,0.00601187356 1072.49586,0.0178367592 C1072.66368,0.0057866107 1072.83185,-0.000127020259 1073,9.92687204e-05 L1073,0.0725499097 C1074.42332,0.279975174 1075.79388,0.93277591 1076.8855,2.03074021 L1079.94548,5.11740181 C1082.63201,7.8270408 1087.03086,7.8270408 1089.71693,5.11740181 L1092.77999,2.03074021 C1095.46652,-0.676913405 1099.86276,-0.676913405 1102.54883,2.03074021 L1105.61389,5.11740181 C1108.29842,7.8270408 1112.69712,7.8270408 1115.38334,5.11740181 L1118.44594,2.03074021 C1121.13493,-0.676913405 1125.53179,-0.676913405 1128.21785,2.03074021 L1131.28045,5.11978426 C1133.96991,7.82743787 1138.36599,7.82743787 1141.05221,5.11978426 L1144.11527,2.03074021 C1146.80196,-0.676913405 1151.19758,-0.676913405 1153.88704,2.03074021 L1156.94732,5.11740181 C1159.63324,7.8270408 1164.03225,7.8270408 1166.71862,5.11740181 L1169.78153,2.03074021 C1172.46775,-0.676913405 1176.86445,-0.676913405 1179.55314,2.03074021 L1182.61343,5.11740181 C1185.30227,7.8270408 1189.69866,7.8270408 1192.38488,5.11740181 L1195.44779,2.03074021 C1198.13416,-0.676913405 1202.53025,-0.676913405 1205.21724,2.03074021 L1208.2803,5.11740181 C1210.96667,7.8270408 1215.36291,7.8270408 1218.05175,5.11740181 L1221.11435,2.03074021 C1222.20395,0.93170321 1223.57579,0.277916034 1225,0.0714983408 L1225,9.92687204e-05 C1225.1654,9.92687204e-05 1225.33081,0.00601187356 1225.49586,0.0178367592 C1225.66368,0.0057866107 1225.83185,-0.000127020259 1226,9.92687204e-05 L1226,0.0725499097 C1227.42332,0.279975174 1228.79388,0.93277591 1229.8855,2.03074021 L1232.94548,5.11740181 C1235.63201,7.8270408 1240.03086,7.8270408 1242.71693,5.11740181 L1245.77999,2.03074021 C1248.46652,-0.676913405 1252.86276,-0.676913405 1255.54883,2.03074021 L1258.61389,5.11740181 C1261.29842,7.8270408 1265.69712,7.8270408 1268.38334,5.11740181 L1271.44594,2.03074021 C1274.13493,-0.676913405 1278.53179,-0.676913405 1281.21785,2.03074021 L1284.28045,5.11978426 C1286.96991,7.82743787 1291.36599,7.82743787 1294.05221,5.11978426 L1297.11527,2.03074021 C1299.80196,-0.676913405 1304.19758,-0.676913405 1306.88704,2.03074021 L1309.94732,5.11740181 C1312.63324,7.8270408 1317.03225,7.8270408 1319.71862,5.11740181 L1322.78153,2.03074021 C1325.46775,-0.676913405 1329.86445,-0.676913405 1332.55314,2.03074021 L1335.61343,5.11740181 C1338.30227,7.8270408 1342.69866,7.8270408 1345.38488,5.11740181 L1348.44779,2.03074021 C1351.13416,-0.676913405 1355.53025,-0.676913405 1358.21724,2.03074021 L1361.2803,5.11740181 C1363.96667,7.8270408 1368.36291,7.8270408 1371.05175,5.11740181 L1374.11435,2.03074021 C1375.45754,0.675920717 1377.22962,-0.00228318057 1379,9.92687204e-05 Z"/>
					</svg>';
				break;
				case '8':
				$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
				$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '180';
				$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="1289" height="180" viewBox="0 0 1289 180" preserveAspectRatio="none">
					<path d="M1289,180 L0,180 L0,-8.52651283e-13 C38.8965489,38.2218937 81.0214459,66.1364916 125.852382,85.6442316 C236.517558,135.473729 363.793972,133.698352 489.868349,145.261954 C521.559873,147.528163 553.339108,150.037752 585.162198,152.951639 C601.075737,154.405202 617.003229,155.950713 632.946669,157.570594 C648.892103,159.189117 664.855473,160.883365 680.848752,162.604657 C744.851753,169.393805 809.043093,173.824391 875.5,176 C1000.41286,180.81013 1134.36393,164.088068 1289,72.0437939 L1289,180 Z" transform="matrix(-1 0 0 1 1289 0)"/>
				</svg>';
				break;
				case '9':
				$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
				$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '180';
				$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="1440" height="32" viewBox="0 0 1440 32" preserveAspectRatio="none">
							<path d="M25.212,8.243 C26.1416837,8.4679854 27.1157923,8.4281481 28.024,8.128 C29.56,7.776 31.087,7.428 32.67,9.415 C34.27,10.623 35.828,10.544 37.403,10.472 C38.3146415,10.3824791 39.2342654,10.4188199 40.136,10.58 C41.365,9.911 42.601,9.048 43.892,9.89 C44.609,11.58 45.286,11.213 45.963,10.846 C46.546,10.53 47.136,10.213 47.763,11.22 C50.33,10.314 52.756,11.155 55.008,11.27 C57.284,12.456 59.387,12.708 61.324,11.191 C63.261,9.674 65.124,10.407 66.924,11.759 C68.601,8.307 70.318,10.63 71.924,10.731 C72.837,12.241 73.68,11.795 74.515,11.349 C75.208,10.982 75.893,10.608 76.594,11.371 C77.4442987,11.2641116 78.3049212,11.2688181 79.154,11.385 C79.7473122,11.455217 80.3446047,11.4862843 80.942,11.478 C82.966,11.399 83.588,9.522 84.462,13.218 C88.88,11.801 113.814,4.007 115.326,5.035 C116.826,5.459 134.889,3.467 136.889,3.302 C137.918433,3.79409931 139.110753,3.81526043 140.157,3.36 C140.860903,3.07695231 141.627164,2.98518042 142.378,3.094 C143.949101,2.40157365 145.719045,2.30697745 147.355,2.828 C148.453595,3.19304431 149.63425,3.23297825 150.755,2.943 C151.900669,2.41883216 152.983521,1.76704077 153.983,1 C155.023,1.978 155.968,1.367 156.913,2.51 C158.813,4.466 173.546,5.552 175.389,4.998 C177.248,5.53 187.706,12.764 190.037,12.298 C191.163,10.069 215.553,8.149 216.947,8.228 C218.309,7.056 219.798,6.035 221.515,8.465 C223.873007,8.49815884 226.219396,8.80215252 228.508,9.371 C229.65,9.723 229.8,10.071 229.626,10.263 C229.342,13.269 227.665,11.392 229.988,10.982 C230.311,11.126 230.697,10.853 231.169,10.582 C231.970786,9.96377523 233.101164,10.0123164 233.847,10.697 C234.659719,10.5496435 235.494467,10.5765708 236.296,10.776 C238.064581,11.2063029 239.930563,10.9493328 241.517,10.057 C243.738,10.165 245.636,11.502 247.172,10.388 C248.763,11.129 249.991,9.101 251.015,9.036 C253.149,12.2 254.228,10.836 254.779,7.763 C255.464,6.713 255.519,6.756 255.63,6.799 C255.709,6.835 255.819,6.864 256.23,6.468 C256.521,7.784 256.876,7.18 257.43,6.576 C257.93,6.03 258.58,5.476 259.47,6.396 C260.029,4.066 260.754,4.677 261.596,5.289 C261.956823,5.61944872 262.422234,5.81269138 262.911,5.835 C264.321,5.957 266.045,6.914 268.093,7.82 C268.904775,8.19913972 269.829026,8.26085158 270.684,7.993 C271.747,7.777 272.771,7.569 273.784,8.762 C275.532,8.999 277.202,11.947 278.643,9.503 C280.131,9.203 281.47,7.475 282.785,8.633 C283.189186,9.1373972 283.864636,9.33688054 284.478,9.133 C285.124,9.033 285.738,8.924 286.36,10.104 C286.935,11.197 290.502,10.615 293.76,10.032 C295.351312,9.69131803 296.964633,9.46308719 298.588,9.349 C301.848667,9.39966667 305.106333,9.45233333 308.361,9.507 C310.401,9.536 314.461,9.212 319.119,8.889 C328.373,8.249 339.942,7.609 342.533,9.745 C344.407,11.291 344.588,10.27 344.722,9.932 C344.856,9.817 344.895,8.472 346.494,10.378 C348.045,9.918 351.022,6.322 357.194,10.105 C358.928255,8.9615439 360.952958,8.33706411 363.03,8.305 C365.030915,8.37769635 366.953212,9.10250849 368.504,10.369 C372.024,12.159 375.214,11.347 378.12,8.869 C379.349197,8.97817426 380.579941,8.6771693 381.62,8.013 C383.227,7.229 384.762,6.438 386.274,7.984 C391.834,4.856 415.602,6.014 419.831,8.991 C420.847,9.703 421.863,11.723 422.8,10.868 C423.737,10.235 424.69,11.436 425.6,12.177 C426.482,11.444 427.356,11.882 428.16,10.638 C428.96,11.472 429.144,10.667 428.932,9.869 C428.688,8.969 427.94,8.069 426.995,9.509 C426.054636,9.21192283 425.053142,9.16470857 424.089,9.372 C422.930737,9.65437281 421.709639,9.51246712 420.647,8.972 C418.82,7.778 417.93,8.26 419.718,9.403 C420.639,11.057 422.199,11.733 424.593,9.669 C426.066423,9.73576989 427.539062,9.52093224 428.932,9.036 C430.617,8.597 432.539,7.965 434.776,8.856 C437.721,8.173 440.045,9.704 441.809,9.971 C443.11257,9.8607981 444.386622,9.52231449 445.573,8.971 C445.971755,8.82720588 446.416188,8.89494337 446.754,9.151 C447.054,9.41 446.88,9.676 446.431,8.669 C445.974,6.728 445.331,7.36 444.667,7.993 C444.226,8.41 443.777,8.834 443.36,8.493 C443.207453,8.6517684 442.98988,8.73078077 442.771002,8.70689609 C442.552125,8.68301142 442.356713,8.55893274 442.242,8.371 C441.998,8.071 441.966,7.771 442.321,8.364 C442.959,7.156 444.967,8.501 449.275,8.522 C452.910638,8.39210889 456.506845,7.72314897 459.946,6.537 C465.16,4.984 469.746,3.423 473.059,5.703 C475.122,7.127 477.036,6.314 478.84,5.473 C480.628652,6.15442802 482.577226,6.29934603 484.447,5.89 C485.806119,5.59160822 487.215822,5.61145836 488.566,5.948 C489.332942,6.3978646 490.229849,6.57414349 491.11,6.448 C491.879485,6.31890583 492.669933,6.46024644 493.347,6.848 C494.182,7.696 494.962,7.265 495.702,6.841 C496.285,6.496 496.852,6.158 497.411,6.453 C499.9,6.553 532.48,4.698 534.197,2.534 C535.922,0.485 528.125,8.869 529.377,9.07 C531.85,7.891 533.512,8.063 535.189,8.876 C538.512,8.761 538.497,8.107 539.064,8.376 C539.348,8.901 539.757,8.585 540.764,6.916 C542.576347,6.42318619 544.500884,6.54450267 546.237,7.261 C549.001,6.815 550.513,6.427 551.38,6.42 C552.28,7.901 552.427,5.047 552.569,5.011 C552.703,4.86 552.769,5.061 553.333,5.263 C554.619388,5.61880841 555.966315,5.69956267 557.286,5.5 C558.786,6.895 560.137,6.593 561.436,6.737 C562.097,7.337 565.082,5.63 568.043,3.918 C570.973,2.235 573.871,0.546 574.501,1.085 C575.456149,2.18758653 577.107532,2.3489008 578.258,1.452 C579.589,3.242 585.432,6.112 586.945,7.967 C588.445,8.945 590.064,10.067 591.82,8.729 C592.767092,8.98358088 593.767349,8.9610213 594.702,8.664 C595.708264,8.38471761 596.766771,8.35042842 597.789,8.564 C604.428,8.111 604.956,6.939 605.231,6.996 C605.507,6.737 605.491,5.939 611.051,6.809 C614.178,5.22 613.744,5.687 612.272,6.155 C610.994694,6.65441112 609.587655,6.71526556 608.272,6.328 C607.859789,6.34763214 607.45117,6.24312607 607.099,6.028 C606.699,5.755 606.823,5.489 607.918,6.057 C609.658,6.474 613.809,6.273 622.125,6.891 C624.61384,7.61559321 627.226328,7.81380312 629.796,7.473 C631.749,7.308 633.442,7.149 634.915,7.782 C638.015,7.12 640.121,7.94 641.601,8.034 C644.57,8.897 645.058,8.717 646.334,8.58 C646.704,9.011 653.753,9.004 661.1,9.004 C668.393,9.004 675.985,9.004 677.654,9.414 C679.389049,9.97110096 681.224995,10.1417596 683.033,9.914 C684.773,9.547 700.816,9.964 703.769,14.624 C708.408,12.711 745.595,13.373 744.304,14.336 C746.218,12.905 747.698,14.674 748.804,14.904 C749.851,15.357 750.544,13.272 751.049,11.186 C751.624,8.806 751.955,6.426 752.278,7.828 C752.892,8.813 750.459,8.389 749.278,7.965 C748.254,7.598 748.168,7.232 751.767,7.765 C753.72,8.599 755.004,10.828 755.744,10.023 C756.5,10.339 756.807,13.023 756.721,10.152 C756.682,11.852 755.437,10.109 754.587,9.109 C755.264,9.909 763.793,9.792 772.228,9.684 C778.268,9.598 784.254,9.519 787.278,9.77 C788.42,8.008 793.303,7.879 794.831,9.57 C795.831,8.592 795.131,7.111 793.406,6.564 C807.574,7.064 807.448,8.923 821.624,9.426 C828.485262,9.63305486 835.352762,9.41463611 842.187,8.772 C847.387,8.11 846.408,8.118 844.92,8.118 C843.943,8.118 842.754,8.118 842.912,7.938 C841.683,9.347 841.053,8.866 843.345,7.305 C844.463,5.054 846.393,7.118 849.322,7.593 C849.959933,7.87146094 850.682495,7.88441525 851.33,7.629 C852.422977,7.21051493 853.658997,7.45367903 854.512,8.255 C855.445067,8.18572395 856.382602,8.20514433 857.312,8.313 C858.687796,8.47324077 860.079056,8.44430525 861.447,8.227 C864.947,8.083 868.157,7.803 871.102,7.673 C873.806416,7.48551633 876.52332,7.60123629 879.202,8.018 C881.536296,8.85001966 884.068025,8.95462214 886.463,8.318 C888.235,7.994 889.849,7.671 891.338,8.167 C910.263,11.885 926.959,5.167 944.883,4.421 C945.403,4.399 955.499,7.139 958.153,7.348 C960.568247,7.41846995 962.975618,7.04041093 965.253,6.233 C968.639,5.255 971.931,4.27 975.822,6.168 C978.83,5.974 980.799,6.283 982.138,5.14 C984.8,2.451 985.083,4.809 986.312,4.91 C986.912,3.587 987.769,3.853 989.32,4.5 C990.82,2.228 993.02,1.8 996.337,1.329 C999.261995,1.97370864 1002.26801,2.16995108 1005.252,1.911 C1006.575,1.724 1007.985,3.364 1009.331,5.003 C1010.677,6.642 1011.938,8.275 1012.977,8.103 C1017.151,7.974 1020.333,7.139 1023.002,5.025 C1024.23708,5.33124262 1025.51407,5.43259102 1026.782,5.325 C1027.91066,5.20812695 1029.05121,5.30308851 1030.145,5.605 C1032.082,7.295 1031.791,7.151 1030.885,7.005 C1030.07132,6.78533437 1029.20205,6.94084981 1028.515,7.429 C1027.664,6.084 1027.271,7.681 1028.315,7.853 C1029.362,8.205 1031.827,7.163 1036.797,6.453 C1038.49265,6.43243786 1040.16445,6.8535766 1041.648,7.675 C1043.31,8.559 1044.2,9.437 1044.609,8.509 C1045.326,8.2 1044.688,7.186 1044.27,7.035 C1043.87,7.574 1043.687,9.214 1045.207,7.186 C1046.727,5.122 1050.043,4.734 1056.713,7.208 C1059.29219,6.58055568 1061.9807,6.55113943 1064.573,7.122 C1066.518,4.792 1067.952,7 1068.967,8.186 C1070.975,8.157 1071.361,6.547 1071.653,7.474 C1071.929,7.201 1072.07,7.674 1073.527,7.905 C1074.244,7.114 1075.307,8.236 1076.898,9.372 C1077.685,10.292 1078.583,9.645 1079.631,8.998 C1080.679,8.351 1081.883,7.698 1083.285,8.624 C1085.14458,9.5272683 1087.24082,9.82388358 1089.278,9.472 C1090.50655,9.27744528 1091.76123,9.32397786 1092.972,9.609 C1095.831,13.765 1098.178,10.191 1100.265,10.062 C1101.93452,9.54909729 1103.72889,9.61963062 1105.353,10.262 C1107.078,10.78 1108.553,11.297 1109.853,10.046 C1111.21114,10.2975652 1112.60325,10.3050151 1113.964,10.068 C1114.79878,9.95093404 1115.64108,9.89578354 1116.484,9.903 C1117.24,10.403 1117.476,10.083 1117.358,9.766 C1117.216,9.366 1116.547,8.975 1115.658,10.082 C1114.02,11.614 1111.523,11.282 1109.87,11.614 C1109.3753,11.2651233 1108.69329,11.3698102 1108.326,11.851 C1107.972,12.29 1108.126,12.735 1109.043,11.427 C1110.681,9.752 1114.816,9.601 1123.124,10.14 C1128.668,11.449 1132.858,12.362 1136.04,11.593 C1137.623,9.774 1138.985,10.407 1140.151,11.039 C1141.317,11.671 1142.262,12.297 1143.026,10.539 C1146.2,9.065 1146.94,8.82 1148.169,9.065 C1148.586,9.791 1149.043,9.611 1149.657,9.432 C1150.00965,9.31492989 1150.38083,9.26374445 1150.752,9.281 C1151.965,8.404 1153.705,9.49 1156.288,9.781 C1158.178,6.991 1159.926,10.996 1161.423,11.974 C1162.187,13.031 1162.88,13.274 1163.51,13.009 C1164.164,14.145 1164.731,12.309 1165.25,11.003 C1165.40333,11.2023315 1165.67027,11.2757995 1165.904,11.183 C1166.204,11.111 1166.487,11.039 1166.77,11.909 C1167.235,12.88 1167.621,10.37 1167.983,9.745 C1168.723,8.745 1169.369,11.334 1169.857,11.478 C1170.818,11.118 1168.912,6.919 1169.164,8.078 C1169.274,7.366 1169.864,8.732 1170.464,10.099 C1171.133,11.652 1171.811,13.199 1171.795,11.724 C1171.795,11.976 1171.295,10.976 1170.881,9.984 C1170.467,8.992 1170.133,7.978 1170.495,8.244 C1170.771,8.244 1171.448,9.689 1172.251,11.144 C1173.574,13.517 1175.244,15.897 1176.051,11.87 C1177.469,13.603 1183.974,13.639 1186.029,15.724 C1186.761,17.982 1187.494,17.572 1188.258,17.155 C1188.56867,16.9441365 1188.93766,16.8360609 1189.313,16.846 C1189.974,14.229 1190.699,14.732 1191.455,15.235 C1191.967,15.573 1192.487,15.904 1193.007,15.293 C1194.314,14.941 1195.637,11.317 1197.126,13.776 C1197.795,13.076 1198.496,13.79 1199.213,14.509 C1200.032,15.329 1200.875,16.148 1201.702,14.847 C1202.602,22.009 1203.348,17.817 1204.159,17.055 C1204.545,15.926 1204.946,16.336 1205.359,16.746 C1205.808,17.185 1206.259,17.63 1206.674,16.146 C1208.344,12.881 1210.116,12.146 1211.998,14.737 C1213.471,13.169 1216.518,13.205 1219.732,13.237 C1224.016,13.287 1228.608,13.337 1230.198,9.606 C1230.584,12.554 1238.829,13.496 1240.767,10.806 C1241.216,11.561 1241.667,12.316 1242.122,13.071 C1248.257,10.95 1250.022,4.262 1252.99,8.217 L1255.376,6.017 C1260.109,7.11 1269.89,8.577 1273.93,6.628 C1275.51965,5.92476342 1277.28402,5.71571498 1278.994,6.028 C1280.679,6.244 1282.357,6.682 1284.019,6.761 C1285.61,7.661 1287.169,7.161 1288.713,6.668 C1290.39,6.122 1292.044,5.575 1293.69,6.862 C1295.659,9.005 1297.525,7.462 1299.345,7.243 C1301.133,5.388 1302.881,5.287 1304.566,7.049 C1307.039,5.769 1309.323,5.309 1311.378,6.984 C1312.394,7.077 1313.386,9.594 1314.26,8.71 C1315.15,9.271 1315.96,8.66 1316.678,7.351 C1319.655,9.781 1321.356,9.861 1321.324,7.495 C1322.824,8.415 1324.254,8.027 1325.648,7.639 C1327.026,7.265 1328.357,6.884 1329.664,7.747 C1332.264,6.374 1334.696,4.878 1337.02,6.316 C1339.11306,5.6876009 1341.27803,5.33002182 1343.462,5.252 C1344.54451,4.76398544 1345.74258,4.59070411 1346.919,4.752 C1347.62304,4.82007336 1348.33302,4.79350362 1349.03,4.673 C1350.86341,4.4811641 1352.71603,4.73538433 1354.43,5.414 C1356.241,5.96 1357.919,6.514 1359.124,6.133 C1360.613,3.487 1364.944,3.969 1368.582,4.45 C1370.17283,4.78883897 1371.80663,4.87857488 1373.425,4.716 C1376.58748,3.9606856 1379.89766,4.09917219 1382.986,5.116 C1385.254,5.749 1386.806,6.382 1387.152,5.763 C1388.711,5.274 1390.326,4.483 1391.987,4.763 C1393.121,2.699 1394.187,3.102 1395.2,3.505 C1395.59912,3.70664856 1396.03714,3.81956458 1396.484,3.836 C1398.984,4.188 1403.391,5.044 1405.714,3.599 C1407.848,4.843 1417.014,5.591 1417.149,5.454 L1424.56,5.612 C1435.365,4.663 1438.271,4.253 1440.649,5.598 C1440.649,5.598 1440.759,14.457 1440.799,17.427 C1440.899,25.854 1440.887,24.565 1440.999,33 L0.992229298,33 C0.992229298,33 1.439,23.81 1.219,14.621 C1.184,13.3 1.152,11.975 1.121,10.637 C1.089,9.271 1.081,9.055 1.011,6.3 C0.932,2.82 1.318,18.884 1.318,18.912 C1.215,14.47 1.145,10.026 1.2,5.582 C8.319,6.272 18.912,5.934 25.212,8.243 Z" transform="translate(-1 -1)"/>
						</svg>';
				break;
			}

			return '<div class="one-row_' . $pos . '_divider" style="height:' . ( isset( $height ) ? $height : '' ) . 'px;">' . $svg . '</div>';

		}

	}

	new Liquid_Shape_Divider_Options;

}